

DROP FUNCTION if exists public.p_est_prod_desc_final(integer, integer, integer, integer, integer);
DROP FUNCTION if exists public.p_est_prod_desc_final(integer, integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION PUBLIC.p_est_prod_desc_final(
    IN INTEGER,
    IN INTEGER,
    IN INTEGER,
    IN INTEGER,
    IN INTEGER,
    IN INTEGER,
	
    OUT VERSAO            CHARACTER VARYING,
    OUT CD_TP_DESCONTO    INTEGER,
    OUT CD_PROD           INTEGER,
    OUT CD_TBL_DESC       INTEGER,
    OUT DS_TBL_DESC       CHARACTER VARYING,
    OUT QT_IT             INTEGER,
    OUT VLR_DESC_ITEM     DOUBLE PRECISION,
    OUT VLR_DESCONTO      DOUBLE PRECISION,
    OUT VLR_ITEM 		  DOUBLE PRECISION,
    OUT AGREGACAO 		  INTEGER,
	OUT QTDE_LIMITE_VENDA INTEGER)
  RETURNS SETOF RECORD AS
$BODY$
 
 
--SELECT * FROM p_est_prod_desc_final(1,1,106,895842)
---------------------------------------------------------
----DECLARA AS VARIVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
DECLARE IN_CD_EMP    	ALIAS FOR $1;
DECLARE IN_CD_FILIAL 	ALIAS FOR $2;
DECLARE IN_NR_CX     	ALIAS FOR $3;
DECLARE IN_CD_VD 	 	ALIAS FOR $4;
DECLARE IN_TP_PDV 	 	ALIAS FOR $5;
DECLARE IN_CD_FRM_PGTO 	ALIAS FOR $6;

---------------------------------------------------------
----DECLARA VARIAVEIS
---------------------------------------------------------

DECLARE TMP_CD_ARV_MERC INTEGER;
DECLARE TMP_PERC_DESC 	NUMERIC(10,2);
DECLARE TMP_QTDE_ITENS 	INTEGER;
DECLARE TMP_CD_EMP 		INTEGER;
DECLARE TMP_CD_PROD 	INTEGER;
DECLARE TMP_CD_IT 		INTEGER;
DECLARE TMP_CD_TBL_DESC INTEGER;
DECLARE TMP_QTDE_ITENS2 INTEGER;
DECLARE TMP_DS_TBL_DESC CHARACTER VARYING( 255 );
DECLARE TMP_COUNT 		INTEGER = 0;
DECLARE TMP_QTDE_MULT   INTEGER;
DECLARE TMP_TRABALHACOMDESCONTOFORMADEPAGAMENTO   INTEGER;
BEGIN RAISE NOTICE 'PROCEDURE p_est_prod_desc_final INICIADA';
---------------------------------------------------------
----TABELA DE CODIGO DE TABELA DE DESCONTO
---------------------------------------------------------

BEGIN 
	CREATE TEMPORARY TABLE
		RS_TAB_ATIVA_QTDE ( CD_EMP INTEGER, CD_TBL_DESC INTEGER, TP_DESC INTEGER );

	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE 	RS_TAB_ATIVA_QTDE;
	--TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
END;
BEGIN 
	CREATE TEMPORARY TABLE
		RS_TAB_QTDE_ATIVA ( CD_EMP INTEGER, CD_TBL_DESC_QTDE INTEGER, TP_DESC INTEGER );
 	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE RS_TAB_QTDE_ATIVA;
	-- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
END;


BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_ITENS (   VERSAO CHARACTER VARYING( 255 ),
							CD_TP_DESCONTO   	INTEGER, 
		                    CD_EMP 				INTEGER, 
							CD_PROD 			INTEGER, 
							CD_IT 				INTEGER, 
							QT_IT 				INTEGER, 
							CD_ARV_MERC_FAMILIA INTEGER, 
							CD_ARV_MERC_CATEG INTEGER, 
							CD_ARV_MERC_LINHA INTEGER, 
							CD_MC 			INTEGER, 
							CD_FABRIC 		INTEGER, 
							CD_TBL_DESC 	INTEGER, 
							DS_TBL_DESC 	CHARACTER VARYING( 255 ), 
							VLR_ITEM 		DOUBLE PRECISION, 
							VLR_ITEM_LIQ 	DOUBLE PRECISION,
							VLR_OFERTA  	DOUBLE PRECISION,							
							PERC_DESC 		 NUMERIC(10,2), 
							PERC_DESC_OFERTA NUMERIC(10,2), 
							SALDO 			INTEGER, 
							AGREGACAO 		INTEGER,
							QTDE_LIMITE_VENDA INTEGER );

	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_ITENS;
END;

---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM PRODUTO
---------------------------------------------------------
BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_PROD (  QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_PROD INTEGER, CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );
	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_PROD;
END;

---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM FAMILIA
---------------------------------------------------------
BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_FAMILIA ( QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_ARV_MERC_FAMILIA INTEGER, CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );
	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_FAMILIA;
END;

---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM CATEGORIA
---------------------------------------------------------
BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_CATEGORIA (  QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_ARV_MERC_CATEG INTEGER, CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );
	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_CATEGORIA;
END;
---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM LINHA
---------------------------------------------------------
BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_LINHA (  QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_ARV_MERC_LINHA INTEGER, CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );

 	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_LINHA;
END;
---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM MARCA
---------------------------------------------------------
 BEGIN 
	CREATE TEMPORARY TABLE 
 		TEMP_INFO_MARCA (   QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_MC INTEGER, CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );

 	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_MARCA;
END;
---------------------------------------------------------
----TABELA DE INFORMACOES AGRUPADA EM FABRIC
---------------------------------------------------------

BEGIN 
	CREATE TEMPORARY TABLE
		TEMP_INFO_FABRIC (QTDE_ITENS INTEGER, PERC_DESC NUMERIC(10,2), CD_FABRIC INTEGER, 
	CD_TBL_DESC INTEGER, DS_TBL_DESC CHARACTER VARYING ( 255 ) );

	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_FABRIC;
END;

---------------------------------------------------------
----TABELA DE INFORMACOES DA CAMPANHA
---------------------------------------------------------
 BEGIN 
	CREATE TEMPORARY TABLE 
 		TEMP_INFO_CAMPANHA ( CD_PROD INTEGER, CD_CAMPANHA_ADIC INTEGER, DS_CAMPANHA_ADIC CHARACTER VARYING(255), QT_IT INTEGER, VLR_DESCONTO NUMERIC(10,2),
							VLR_ITEM NUMERIC(10,2), VLR_VENDA NUMERIC(10,2), AGREGACAO INTEGER, QT_IT_SLD INTEGER, CD_TP_DESCONTO INTEGER default 20 not NULL );
 	EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE TEMP_INFO_CAMPANHA;
END;



TRUNCATE TABLE TEMP_INFO_CAMPANHA;




--CAPTURA ITENS DE CAMPANHA DA COMPRA
INSERT INTO TEMP_INFO_CAMPANHA
SELECT *, Z.QT_IT FROM P_EST_PACK_VIRTUAL( IN_CD_EMP, IN_CD_FILIAL, IN_NR_CX, IN_CD_VD, IN_TP_PDV ) AS Z;
 
 
 
 
---------------------------------------------------------
----CARREGA LISTA DE TABELA DE DESCONTOS ATIVOS
---------------------------------------------------------
	RAISE NOTICE 'INSERT 1';
	--CARREGA DESCONTOS QTDE
	INSERT INTO RS_TAB_ATIVA_QTDE 
	SELECT
		A.CD_EMP,
		A.CD_TBL_DESC,
		A.CD_TP_DESCONTO
	FROM
		EST_PROD_TBL_DESC A
		INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON
		A.CD_EMP = FIL.CD_EMP
		AND A.CD_TBL_DESC = FIL.CD_TBL_DESC
	WHERE
		IN_CD_EMP = A.CD_EMP
		AND IN_CD_FILIAL = FIL.CD_FILIAL
		AND CURRENT_DATE BETWEEN CAST( A.DT_INI AS DATE ) AND CAST( A.DT_FIM AS DATE )
		AND 1 = A.STS_TBL_DESC
		AND 14 = A.CD_TP_DESCONTO;


	RAISE NOTICE 'INSERT 2';
	--CARREGA DESCONTOS PAGUE LEVE
	INSERT INTO RS_TAB_QTDE_ATIVA 
	SELECT
		A.CD_EMP,
		A.CD_TBL_DESC_QTDE,
		A.CD_TP_DESCONTO
	FROM
		EST_PROD_TBL_DESC_QTDE A
		INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
		A.CD_EMP = FIL.CD_EMP
		AND A.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE
	WHERE
		IN_CD_EMP = A.CD_EMP
		AND IN_CD_FILIAL = FIL.CD_FILIAL
		AND CURRENT_DATE BETWEEN CAST( A.DT_INI AS DATE ) AND CAST( A.DT_FIM AS DATE )
		AND A.STS_TBL_DESC = 1
		AND A.CD_TP_DESCONTO = 24;


 
-------------------------------------------------------------------------------------------------------------------------------
-- VALIDA FORMA DE PAGAMENTO 
-------------------------------------------------------------------------------------------------------------------------------	
	TMP_TRABALHACOMDESCONTOFORMADEPAGAMENTO = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'USA_DESCONTO_PGTO' and cd_filial = IN_CD_FILIAL), 0);
	
	 if TMP_TRABALHACOMDESCONTOFORMADEPAGAMENTO = 1 then  
			 
	
			delete from RS_TAB_ATIVA_QTDE a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_forma_pgto b  
				    			where b.cd_emp        = a.cd_emp
				    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
				    			  and b.cd_forma_pgto = IN_CD_FRM_PGTO  
				    			    ) ;
									
									
			delete from RS_TAB_QTDE_ATIVA a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_qtde_forma_pgto b  
				    			where b.cd_emp             = a.cd_emp
				    			  and b.cd_tbl_desc_qtde   = a.cd_tbl_desc_qtde   
				    			  and b.cd_frm_pgto      = IN_CD_FRM_PGTO  
				    			    ) ;						
	
		end if ; 
		
		 

/*****************************************************************************************************************************/
/*****************************************************************************************************************************/
			
 IF ( IN_TP_PDV = 1 ) THEN
 
---------------------------------------------------------
----CARREGA INFORMACOES DE ITENS NFCE
---------------------------------------------------------
	INSERT INTO TEMP_INFO_ITENS 
	SELECT
	    '16/07/2021 00:00' VERSAO,
	    0 AS CD_TP_DESCONTO,	
	    IT.CD_EMP,
		IT.CD_PROD,
		IT.CD_IT,
		IT.QT_IT,
		ARV.CD_ARV_MERC_FAMILIA,
		ARV.CD_ARV_MERC_CATEG,
		ARV.CD_ARV_MERC_LINHA,
		ARV.CD_MC,
		EP.CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC,
		IT.VLR_IT,
		IT.VLR_IT,
		V.VLR_OFERTA,
		0 AS PERC_DESC,
		0 AS PERC_DESC_OFERTA,
		IT.QT_IT AS SALDO,
		0 AGREGACAO,
		EP.QTDE_LIMITE_VENDA
	FROM
		PDV_VD_IT IT
		INNER JOIN PDV_VD VD ON
			VD.CD_EMP = IT.CD_EMP
			AND VD.CD_FILIAL = IT.CD_FILIAL
			AND VD.CD_VD = IT.CD_VD
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
			ARV.CD_EMP = IT.CD_EMP
			AND ARV.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD EP ON
			EP.CD_EMP = IT.CD_EMP
			AND EP.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD_PRECO V ON 
				V.CD_EMP  = IT.CD_EMP
			AND V.CD_PROD = IT.CD_PROD
			AND V.CD_FILIAL  = IT.CD_FILIAL 
	WHERE
		IT.CD_EMP = IN_CD_EMP
		AND VD.CD_FILIAL = IN_CD_FILIAL
		AND VD.CD_CX = IN_NR_CX
		AND VD.CD_VD = IN_CD_VD
		AND VD.ST_VD=1
	ORDER BY
		IT.CD_IT;

 ELSIF ( IN_TP_PDV = 0 ) THEN
---------------------------------------------------------
----CARREGA INFORMACOES DE ITENS PAF
---------------------------------------------------------
	RAISE NOTICE 'INSERT ITENS PAF ';
	INSERT INTO TEMP_INFO_ITENS 
	SELECT
		'16/07/2021 00:00' VERSAO,
	    0 AS CD_TP_DESCONTO,
		IT.CD_EMP,
		IT.CD_PROD,
		IT.CD_IT,
		IT.QT_IT,
		ARV.CD_ARV_MERC_FAMILIA,
		ARV.CD_ARV_MERC_CATEG,
		ARV.CD_ARV_MERC_LINHA,
		ARV.CD_MC,
		EP.CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC,
		IT.VL_UNIT,
		IT.VL_UNIT,
		V.VLR_OFERTA,
		0 AS PERC_DESC,
		0 AS PERC_DESC_OFERTA,
		IT.QT_IT AS SALDO,
		0 AGREGACAO,
		EP.QTDE_LIMITE_VENDA
	FROM
		PDV_CUPOM_IT IT
		INNER JOIN PDV_CUPOM VD ON
			VD.CD_EMP = IT.CD_EMP
			AND VD.CD_FILIAL = IT.CD_FILIAL
			AND VD.CD_CTR = IT.CD_CTR
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
			ARV.CD_EMP = IT.CD_EMP
			AND ARV.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD EP ON
			EP.CD_EMP = IT.CD_EMP
			AND EP.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD_PRECO V ON 
				V.CD_EMP  = IT.CD_EMP
			AND V.CD_PROD = IT.CD_PROD
			AND V.CD_FILIAL  = IT.CD_FILIAL 
	WHERE
		IT.CD_EMP = IN_CD_EMP
		AND VD.CD_FILIAL = IN_CD_FILIAL
		AND VD.CD_CX = IN_NR_CX
		AND VD.CD_CTR = IN_CD_VD
	ORDER BY
		IT.CD_IT;

 ELSIF ( IN_TP_PDV = 2 ) THEN
---------------------------------------------------------
----CARREGA INFORMACOES DE ITENS ORCAMENTO
---------------------------------------------------------
	RAISE NOTICE 'INSERT ITENS DESCONTO_TMP ORCAMENTO';
	INSERT INTO TEMP_INFO_ITENS 
	SELECT 
	    '16/07/2021 00:00' VERSAO,
 	    0 AS CD_TP_DESCONTO, 
		IT.CD_EMP,
		IT.CD_PROD,
		IT.CD_IT,
		IT.QT_IT,
		ARV.CD_ARV_MERC_FAMILIA,
		ARV.CD_ARV_MERC_CATEG,
		ARV.CD_ARV_MERC_LINHA,
		ARV.CD_MC,
		EP.CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC,
		IT.VLR_ITEM,
		IT.VLR_ITEM_LIQ,
		V.VLR_OFERTA,
		0 PERC_DESC,
		0 AS PERC_DESC_OFERTA,
		IT.QT_IT AS SALDO,
		0 AGREGACAO,
		EP.QTDE_LIMITE_VENDA
	FROM
		EST_PROD_DESCONTO_TEMP IT
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
			ARV.CD_EMP = IT.CD_EMP
			AND ARV.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD EP ON
			EP.CD_EMP = IT.CD_EMP
			AND EP.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD_PRECO V ON 
				V.CD_EMP  = IT.CD_EMP
			AND V.CD_PROD = IT.CD_PROD
			AND V.CD_FILIAL  = IT.CD_FILIAL 
	WHERE
		IT.CD_EMP = IN_CD_EMP
		AND IT.CD_FILIAL = IN_CD_FILIAL
		AND IT.CD_CTR_ORC = IN_CD_VD
	ORDER BY
		IT.CD_IT;

 ELSIF ( IN_TP_PDV = 3 ) THEN
---------------------------------------------------------
----CARREGA INFORMACOES DE ITENS PDV
---------------------------------------------------------
	
 RAISE NOTICE 'INSERT ITENS DESCONTO_TMP PDV';
	INSERT INTO TEMP_INFO_ITENS 
	SELECT 
	    '16/07/2021 00:00' VERSAO,
		0 AS CD_TP_DESCONTO,
		IT.CD_EMP,
		IT.CD_PROD,
		IT.CD_IT,
		IT.QT_IT,
		ARV.CD_ARV_MERC_FAMILIA,
		ARV.CD_ARV_MERC_CATEG,
		ARV.CD_ARV_MERC_LINHA,
		ARV.CD_MC,
		EP.CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC,
		IT.VLR_ITEM,
		IT.VLR_ITEM_LIQ,
		V.VLR_OFERTA,
		0 PERC_DESC,
		0 AS PERC_DESC_OFERTA,
		IT.QT_IT AS SALDO,
		0 AGREGACAO,
		EP.QTDE_LIMITE_VENDA
	FROM
		EST_PROD_DESCONTO_TEMP IT
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
			ARV.CD_EMP = IT.CD_EMP
			AND ARV.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD EP ON
			EP.CD_EMP = IT.CD_EMP
			AND EP.CD_PROD = IT.CD_PROD
		INNER JOIN EST_PROD_PRECO V ON 
				V.CD_EMP  = IT.CD_EMP
			AND V.CD_PROD = IT.CD_PROD
			AND V.CD_FILIAL  = IT.CD_FILIAL 
	WHERE
		IT.CD_EMP = IN_CD_EMP
		AND IT.CD_FILIAL = IN_CD_FILIAL
		AND IT.CD_CTR_VD = IN_CD_VD
		AND IT.QT_IT >0  
	ORDER BY
		IT.CD_IT;
		
END IF;


/*****************************************************************************************************************************/
/*****************************************************************************************************************************/
--REMOVER OS ITENS QUE FORAM BRINDES DA PACK_VIRTUAL. POIS NAO PODEM SER CONSIDERADOS PARA EFEITOS DE DESCONTO
 
--COLOCA DESCONTO DOS ITENS DO PACK_VIRTUAL
/*****************************************************************************************************************************/ 
			
DECLARE CURSOR_CAMPANHA REFCURSOR;
BEGIN OPEN CURSOR_CAMPANHA FOR 
	SELECT
		TII.QT_IT,
		TII.CD_PROD,
		TII.CD_IT
	FROM
		TEMP_INFO_ITENS TII;

	FETCH FROM CURSOR_CAMPANHA INTO TMP_QTDE_ITENS, TMP_CD_PROD, TMP_CD_IT;
	LOOP 
		EXIT WHEN NOT FOUND;
		 
		TMP_QTDE_ITENS2 =COALESCE( (SELECT QT_IT_SLD FROM  TEMP_INFO_CAMPANHA
								WHERE TEMP_INFO_CAMPANHA.CD_PROD=TMP_CD_PROD),0);
								
								
		RAISE NOTICE 'ABATENDO QUANTIDADES DE ITENS DE CAMPANHA, %. ', TMP_QTDE_ITENS2;
		
		IF (TMP_QTDE_ITENS2) > 0 THEN
		
			UPDATE 
				TEMP_INFO_ITENS TII
			SET 
				QT_IT = TII.QT_IT - TMP_QTDE_ITENS2
				,SALDO = SALDO - TMP_QTDE_ITENS2
				,PERC_DESC =(1-(TII.VLR_ITEM_LIQ/TII.VLR_ITEM))*100
			WHERE 
				TII.CD_PROD = TMP_CD_PROD AND 
				TMP_CD_IT = TII.CD_IT;
				
			UPDATE 
				TEMP_INFO_CAMPANHA TII
			SET 
				QT_IT_SLD = TII.QT_IT_SLD - TMP_QTDE_ITENS2
			WHERE 
				TII.CD_PROD = TMP_CD_PROD ;
		END IF;			

		/*IF (TMP_QTDE_ITENS = 1) THEN
			DELETE FROM TEMP_INFO_ITENS TII 
				WHERE TII.CD_PROD = TMP_CD_PROD AND 
					TMP_CD_IT = TII.CD_IT
					;
		END IF;
		*/

		FETCH IN CURSOR_CAMPANHA INTO TMP_QTDE_ITENS, TMP_CD_PROD, TMP_CD_IT;
	END LOOP;
END;
/*****************************************************************************************************************************/
/*****************************************************************************************************************************/

	
--ORGANIZA ITENS POR PRODUTO
	RAISE NOTICE 'INSERT PRODUTO';

	INSERT INTO TEMP_INFO_PROD 
	SELECT
	    SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		TEMP_INFO_ITENS.CD_PROD,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		TEMP_INFO_ITENS.CD_PROD;


	--INICIA DESCONTOS PAGUE LEVE
	IF EXISTS( SELECT 1 FROM TEMP_INFO_PROD ) THEN
	-------------------------------------------------------------------------------------------------------------------------------    
	--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------
		RAISE NOTICE 'UPDATE 5';

		UPDATE
			TEMP_INFO_PROD
		SET
			--PERC_DESC = ( CAST( 1 - ( CAST ( A.QTDE_PAGUE AS FLOAT )/ CAST ( A.QTDE_LEVE AS FLOAT )) AS FLOAT )) * 100,		
			PERC_DESC = CAST( 1 -
					 ((FLOOR(( TEMP_INFO_PROD.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
					 (TEMP_INFO_PROD.QTDE_ITENS -(FLOOR(( TEMP_INFO_PROD.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
						TEMP_INFO_PROD.QTDE_ITENS AS FLOAT) * 100 , 
					 
			QTDE_ITENS = FLOOR((TEMP_INFO_PROD.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
			CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
			DS_TBL_DESC = A.DS_TBL_DESC_QTDE 
			
		FROM
			EST_PROD_TBL_DESC_QTDE A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_PROD B ON
				A.CD_EMP = B.CD_EMP
				AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
			INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
				B.CD_EMP = FIL.CD_EMP
				AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE
			INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
				A.CD_EMP = ATV.CD_EMP
				AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
		WHERE
			FIL.CD_FILIAL = IN_CD_FILIAL
			AND TEMP_INFO_PROD.CD_PROD = B.CD_PROD
			AND TEMP_INFO_PROD.QTDE_ITENS >= A.QTDE_LEVE;
	 
	
		--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_PROD10 REFCURSOR;
		BEGIN OPEN CURSOR_PROD10 FOR 
		SELECT
			TIF.QTDE_ITENS,
			TIF.PERC_DESC,
			TIF.CD_PROD,
			TIF.CD_TBL_DESC,
			TIF.DS_TBL_DESC
		FROM
			TEMP_INFO_PROD TIF
		WHERE
			TIF.PERC_DESC > 0;
		
		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_PROD TIF WHERE TIF.PERC_DESC > 0);

		LOOP EXIT WHEN TMP_COUNT = 0;
			FETCH FROM CURSOR_PROD10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		 
		
		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_PROD20 REFCURSOR;
			BEGIN OPEN CURSOR_PROD20 FOR SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				TII.CD_PROD = TMP_CD_ARV_MERC
				AND SALDO > 0
			ORDER BY TII.CD_IT;

			FETCH FIRST FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
										
			LOOP EXIT WHEN NOT FOUND;

				--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
				WHILE ( TMP_QTDE_ITENS ) > 0 
				--CONTINUAR ENQUANTO EXISTIR ALGUM PRODUTO SEM DESCONTO
					LOOP RAISE NOTICE 'CURSOR_PROD20';
			
					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = TII.PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP = TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT = TMP_CD_IT;
			
					TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;
			
					FETCH IN CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN 
						FETCH FIRST FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
					END IF;
				END LOOP;	
				
				MOVE LAST FROM CURSOR_PROD20;
				FETCH NEXT FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;
			END LOOP;
			END;
		END LOOP;
		END;
	END IF;
		

	--ORGANIZA ITENS POR FAMILIA
	RAISE NOTICE 'INSERT 4';

	INSERT INTO TEMP_INFO_FAMILIA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_FAMILIA,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_ARV_MERC_FAMILIA;
		
	--INICIA DESCONTOS PAGUE LEVE
	IF EXISTS( SELECT 1 FROM TEMP_INFO_FAMILIA ) THEN
	-------------------------------------------------------------------------------------------------------------------------------    
	--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
	-------------------------------------------------------------------------------------------------------------------------------
		RAISE NOTICE 'UPDATE 5';
		
		UPDATE
			TEMP_INFO_FAMILIA
		SET
			--PERC_DESC = ( CAST( 1 - ( CAST ( A.QTDE_PAGUE AS FLOAT )/ CAST ( A.QTDE_LEVE AS FLOAT )) AS FLOAT )) * 100,		
			PERC_DESC = CAST( 1 -
					((FLOOR(( TEMP_INFO_FAMILIA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
					 (TEMP_INFO_FAMILIA.QTDE_ITENS -(FLOOR(( TEMP_INFO_FAMILIA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
					 TEMP_INFO_FAMILIA.QTDE_ITENS AS FLOAT) * 100 , 
			QTDE_ITENS = FLOOR((TEMP_INFO_FAMILIA.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
			CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
			DS_TBL_DESC = A.DS_TBL_DESC_QTDE
		FROM
			EST_PROD_TBL_DESC_QTDE A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_FAMILIA B ON
			A.CD_EMP = B.CD_EMP
			AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
			INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
			B.CD_EMP = FIL.CD_EMP
			AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE
			 
			INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
			A.CD_EMP = ATV.CD_EMP
			AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
		WHERE
			FIL.CD_FILIAL = IN_CD_FILIAL
			AND TEMP_INFO_FAMILIA.CD_ARV_MERC_FAMILIA = B.CD_ARV_MERC_FAMILIA
			AND TEMP_INFO_FAMILIA.QTDE_ITENS >= A.QTDE_LEVE;
					
		--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_FAM10 REFCURSOR;
		BEGIN OPEN CURSOR_FAM10 FOR 
		SELECT
			TIF.QTDE_ITENS,
			TIF.PERC_DESC,
			TIF.CD_ARV_MERC_FAMILIA,
			TIF.CD_TBL_DESC,
			TIF.DS_TBL_DESC
		FROM
			TEMP_INFO_FAMILIA TIF
		WHERE
			TIF.PERC_DESC > 0;
		
		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_FAMILIA TIF	WHERE TIF.PERC_DESC > 0);

		LOOP EXIT WHEN TMP_COUNT = 0;
			
			FETCH NEXT FROM CURSOR_FAM10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;

			--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_FAM20 REFCURSOR;
			BEGIN OPEN CURSOR_FAM20 FOR 
			SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				CD_ARV_MERC_FAMILIA = TMP_CD_ARV_MERC
				AND SALDO > 0
			ORDER BY TII.CD_IT;

			FETCH FIRST FROM CURSOR_FAM20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

			LOOP EXIT WHEN NOT FOUND;
				--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
				WHILE ( TMP_QTDE_ITENS ) > 0 
				--CONTINUAR ENQUANTO EXISTIR ALGUM PRODUTO SEM DESCONTO
				LOOP RAISE NOTICE 'CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS - CURSOR_FAM20';
				
					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = TII.PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP 		= TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT 	= TMP_CD_IT;
			
					TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

					FETCH NEXT FROM CURSOR_FAM20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN  
						FETCH FIRST FROM CURSOR_FAM20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
					END IF;

				END LOOP;
				MOVE LAST FROM CURSOR_FAM20;
				FETCH NEXT FROM CURSOR_FAM20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;

			END LOOP;
			END;
		END LOOP;
		END;
	END IF;

/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR MARCA
/***************************************************************************************************************************************************/

	RAISE NOTICE 'INSERT 7';
	INSERT INTO TEMP_INFO_MARCA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_MC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY CD_MC;


	--INICIA DESCONTOS PAGUE LEVE
	IF EXISTS( SELECT 1 FROM TEMP_INFO_MARCA ) THEN
	-------------------------------------------------------------------------------------------------------------------------------        
	--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
	-------------------------------------------------------------------------------------------------------------------------------  
		RAISE NOTICE 'UPDATE 8';

		UPDATE
			TEMP_INFO_MARCA
		SET
			--PERC_DESC = ( 1 - ( A.QTDE_PAGUE / A.QTDE_LEVE )) * 100,
			PERC_DESC = CAST( 1 -
						((FLOOR(( TEMP_INFO_MARCA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
						        ( TEMP_INFO_MARCA.QTDE_ITENS -(FLOOR(( TEMP_INFO_MARCA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
							  TEMP_INFO_MARCA.QTDE_ITENS AS FLOAT) * 100 , 

			QTDE_ITENS = FLOOR(( TEMP_INFO_MARCA.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
			CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
			DS_TBL_DESC = A.DS_TBL_DESC_QTDE
		FROM
			EST_PROD_TBL_DESC_QTDE A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_MC B ON
			A.CD_EMP = B.CD_EMP
			AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
			INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
			B.CD_EMP = FIL.CD_EMP
			AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE			 
			INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
			A.CD_EMP = ATV.CD_EMP
			AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
		WHERE
			FIL.CD_FILIAL = IN_CD_FILIAL
			AND TEMP_INFO_MARCA.CD_MC = B.CD_MC 
			AND TEMP_INFO_MARCA.QTDE_ITENS >= A.QTDE_LEVE;

		--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_MC10 REFCURSOR;

		BEGIN OPEN CURSOR_MC10 FOR 
		SELECT 
			TIM.QTDE_ITENS, TIM.PERC_DESC, TIM.CD_MC, TIM.CD_TBL_DESC, TIM.DS_TBL_DESC
		FROM
			TEMP_INFO_MARCA TIM
		WHERE
			TIM.PERC_DESC > 0;

		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_MARCA TIM WHERE TIM.PERC_DESC > 0);
		
		LOOP EXIT WHEN TMP_COUNT = 0;
		
			FETCH FROM CURSOR_MC10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;

			--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_MC20 REFCURSOR;

			BEGIN OPEN CURSOR_MC20 FOR 
			SELECT
				TII.CD_EMP, TII.CD_PROD, TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				TII.CD_MC = TMP_CD_ARV_MERC
				AND SALDO > 0
			ORDER BY TII.CD_IT;

			FETCH FIRST FROM CURSOR_MC20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

			LOOP EXIT WHEN NOT FOUND;

				--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
				 WHILE ( TMP_QTDE_ITENS ) > 0
					--DAR DESCONTOS 1 ITEM POR VEZ
					 LOOP RAISE NOTICE 'UPDATE 9';

					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP = TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT = TMP_CD_IT;

					 TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

					FETCH CURSOR_MC20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN 
					FETCH FIRST FROM CURSOR_MC20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					END IF;
				END LOOP;

				MOVE LAST FROM CURSOR_MC20;
				FETCH NEXT FROM CURSOR_MC20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;
				
			END LOOP;
			END;
		END LOOP;
		END;
	END IF;

/***************************************************************************************************************************************************/

/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR FABRICANTE
/***************************************************************************************************************************************************/
	RAISE NOTICE 'INSERT 10';
	INSERT INTO TEMP_INFO_FABRIC 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY CD_FABRIC;

 IF EXISTS( SELECT 1 FROM TEMP_INFO_FABRIC ) THEN
-------------------------------------------------------------------------------------------------------------------------------    
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
-------------------------------------------------------------------------------------------------------------------------------   
	RAISE NOTICE 'UPDATE 11';
	UPDATE
		TEMP_INFO_FABRIC
	SET
		--PERC_DESC = ( 1 - ( A.QTDE_PAGUE / A.QTDE_LEVE )) * 100,
		PERC_DESC = CAST( 1 -
						((FLOOR(( TEMP_INFO_FABRIC.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
						        ( TEMP_INFO_FABRIC.QTDE_ITENS -(FLOOR(( TEMP_INFO_FABRIC.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
							  TEMP_INFO_FABRIC.QTDE_ITENS AS FLOAT) * 100 , 

		QTDE_ITENS = FLOOR(( TEMP_INFO_FABRIC.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
		CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
		DS_TBL_DESC = A.DS_TBL_DESC_QTDE
	FROM
		EST_PROD_TBL_DESC_QTDE A
		INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_PROD_FABRIC B ON
		A.CD_EMP = B.CD_EMP
		AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
		INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
		B.CD_EMP = FIL.CD_EMP
		AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE
		INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
		B.CD_EMP = ATV.CD_EMP
		AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
	WHERE
		FIL.CD_FILIAL = IN_CD_FILIAL
		AND TEMP_INFO_FABRIC.CD_FABRIC = B.CD_FABRIC
		AND TEMP_INFO_FABRIC.QTDE_ITENS >= A.QTDE_LEVE; 

	--CURSOR DE LEITURA DE DESCONTOS
	DECLARE CURSOR_FAB10 REFCURSOR;
	BEGIN OPEN CURSOR_FAB10 FOR 
	SELECT
		TI.QTDE_ITENS,TI.PERC_DESC,TI.CD_FABRIC,TI.CD_TBL_DESC,TI.DS_TBL_DESC
	FROM
		TEMP_INFO_FABRIC TI
	WHERE
		TI.PERC_DESC > 0;

	TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_FABRIC TI WHERE TI.PERC_DESC > 0);
	
	LOOP EXIT WHEN TMP_COUNT = 0;
	
		FETCH FROM CURSOR_FAB10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		
		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
		DECLARE CURSOR_FAB20 REFCURSOR;
		BEGIN OPEN CURSOR_FAB20 FOR 
		SELECT
			TII.CD_EMP, TII.CD_PROD, TII.CD_IT
		FROM
			TEMP_INFO_ITENS TII
		WHERE
			TII.CD_FABRIC = TMP_CD_ARV_MERC
			AND SALDO > 0;

		FETCH FIRST FROM CURSOR_FAB20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

		LOOP EXIT WHEN NOT FOUND;
		--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS

		WHILE ( TMP_QTDE_ITENS ) > 0
			--DAR DESCONTOS 1 ITEM POR VEZ
			LOOP RAISE NOTICE 'INSERT 12';

			UPDATE
				TEMP_INFO_ITENS TII
			SET
				SALDO = SALDO - 1,
				PERC_DESC = PERC_DESC + TMP_PERC_DESC,
				CD_TBL_DESC = TMP_CD_TBL_DESC,
				DS_TBL_DESC = TMP_DS_TBL_DESC
			WHERE
				TII.CD_EMP = TMP_CD_EMP
				AND TII.CD_PROD = TMP_CD_PROD
				AND TII.CD_IT = TMP_CD_IT;

			TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

			FETCH CURSOR_FAB20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
		--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO

			IF NOT FOUND THEN 
				FETCH FIRST FROM CURSOR_FAB20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
			END IF;

		END LOOP;

		MOVE LAST FROM CURSOR_FAB20;
		FETCH NEXT FROM CURSOR_FAB20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
		TMP_COUNT = TMP_COUNT -1;
		
	END LOOP;
	END;
END LOOP;
END;

END IF;


/***************************************************************************************************************************************************/

/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR CATEGORIAS
/***************************************************************************************************************************************************/


	RAISE NOTICE 'INSERT 13';
	INSERT INTO TEMP_INFO_CATEGORIA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_CATEG,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_ARV_MERC_CATEG;

 IF EXISTS( SELECT 1 FROM TEMP_INFO_CATEGORIA ) THEN
------------------------------------------------------------------------------------------------------------------------------    
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS         
-------------------------------------------------------------------------------------------------------------------------------  
	RAISE NOTICE 'UPDATE 14';
	UPDATE
		TEMP_INFO_CATEGORIA
	SET
		--PERC_DESC = ( 1 - ( A.QTDE_PAGUE / A.QTDE_LEVE )) * 100,
		PERC_DESC = CAST( 1 - ((FLOOR(( TEMP_INFO_CATEGORIA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
						        ( TEMP_INFO_CATEGORIA.QTDE_ITENS -(FLOOR(( TEMP_INFO_CATEGORIA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
							  TEMP_INFO_CATEGORIA.QTDE_ITENS AS FLOAT) * 100 , 

		QTDE_ITENS = FLOOR(( TEMP_INFO_CATEGORIA.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
		CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
		DS_TBL_DESC = A.DS_TBL_DESC_QTDE
	FROM
		EST_PROD_TBL_DESC_QTDE A
		INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_CATEGORIA B ON
		A.CD_EMP = B.CD_EMP
		AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
		INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
		B.CD_EMP = FIL.CD_EMP
		AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE		
		INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
		A.CD_EMP = ATV.CD_EMP
		AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
	WHERE
		FIL.CD_FILIAL = IN_CD_FILIAL
		AND TEMP_INFO_CATEGORIA.CD_ARV_MERC_CATEG = B.CD_ARV_MERC_CATEG
		AND TEMP_INFO_CATEGORIA.QTDE_ITENS >= A.QTDE_LEVE ;

	--CURSOR DE LEITURA DE DESCONTOS
	DECLARE CURSOR_CAT10 REFCURSOR;
	BEGIN OPEN CURSOR_CAT10 FOR 
	SELECT
		TIC.QTDE_ITENS,
		TIC.PERC_DESC,
		TIC.CD_ARV_MERC_CATEG,
		TIC.CD_TBL_DESC,
		TIC.DS_TBL_DESC
	FROM
		TEMP_INFO_CATEGORIA TIC
	WHERE
		TIC.PERC_DESC > 0;

		
	TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_CATEGORIA TIC WHERE TIC.PERC_DESC > 0);
	
	LOOP EXIT WHEN TMP_COUNT = 0;
	
		FETCH NEXT FROM CURSOR_CAT10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		
		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
		DECLARE CURSOR_CAT20 REFCURSOR;
		BEGIN OPEN CURSOR_CAT20 FOR 
		SELECT
			TII.CD_EMP,
			TII.CD_PROD,
			TII.CD_IT
		FROM
			TEMP_INFO_ITENS TII
		WHERE
			TII.CD_ARV_MERC_CATEG = TMP_CD_ARV_MERC
			AND SALDO > 0
		ORDER BY TII.CD_IT;

		FETCH FIRST FROM CURSOR_CAT20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

		LOOP EXIT WHEN NOT FOUND;
		--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
		
			WHILE ( TMP_QTDE_ITENS ) > 0
				--DAR DESCONTOS 1 ITEM POR VEZ
			LOOP RAISE NOTICE 'UPDATE 15';

				UPDATE
					TEMP_INFO_ITENS TII
				SET
					SALDO = SALDO - 1,
					PERC_DESC = PERC_DESC + TMP_PERC_DESC,
					CD_TBL_DESC = TMP_CD_TBL_DESC,
					DS_TBL_DESC = TMP_DS_TBL_DESC
				WHERE
					TII.CD_EMP = TMP_CD_EMP
					AND TII.CD_PROD = TMP_CD_PROD
					AND TII.CD_IT = TMP_CD_IT;

				TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

				FETCH FROM CURSOR_CAT20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
				IF NOT FOUND THEN 
					FETCH FIRST FROM CURSOR_CAT20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				END IF;
			END LOOP;
			
			MOVE LAST FROM CURSOR_CAT20;
			FETCH FIRST FROM CURSOR_CAT20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
			TMP_COUNT = TMP_COUNT -1;

		END LOOP;
		END;
	END LOOP;
	END;
END IF;

/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR LINHAS
/***************************************************************************************************************************************************/

	RAISE NOTICE 'INSERT 16';

	INSERT INTO TEMP_INFO_LINHA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_LINHA,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_ARV_MERC_LINHA;

 IF EXISTS( SELECT 1 FROM TEMP_INFO_LINHA ) THEN
-------------------------------------------------------------------------------------------------------------------------------    
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
-------------------------------------------------------------------------------------------------------------------------------    
	RAISE NOTICE 'UPDATE 17';
	
	UPDATE
		TEMP_INFO_LINHA
	SET
		--PERC_DESC = ( 1 - ( A.QTDE_PAGUE / A.QTDE_LEVE )) * 100,
		PERC_DESC = CAST( 1 - ((FLOOR(( TEMP_INFO_LINHA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_PAGUE)  +
						        ( TEMP_INFO_LINHA.QTDE_ITENS -(FLOOR(( TEMP_INFO_LINHA.QTDE_ITENS / A.QTDE_LEVE )) *A.QTDE_LEVE)))/
							  TEMP_INFO_LINHA.QTDE_ITENS AS FLOAT) * 100 , 
		QTDE_ITENS = FLOOR(( TEMP_INFO_LINHA.QTDE_ITENS / A.QTDE_LEVE )) * A.QTDE_LEVE,
		CD_TBL_DESC = A.CD_TBL_DESC_QTDE,
		DS_TBL_DESC = A.DS_TBL_DESC_QTDE
	FROM
		EST_PROD_TBL_DESC_QTDE A
		INNER JOIN EST_PROD_TBL_DESC_QTDE_EST_ARV_MERC_LINHA B ON
		A.CD_EMP = B.CD_EMP
		AND A.CD_TBL_DESC_QTDE = B.CD_TBL_DESC_QTDE
		INNER JOIN EST_PROD_TBL_DESC_QTDE_PRC_FILIAL FIL ON
		B.CD_EMP = FIL.CD_EMP
		AND B.CD_TBL_DESC_QTDE = FIL.CD_TBL_DESC_QTDE		
		INNER JOIN RS_TAB_QTDE_ATIVA ATV ON
		A.CD_EMP = ATV.CD_EMP
		AND B.CD_TBL_DESC_QTDE = ATV.CD_TBL_DESC_QTDE
	WHERE
		FIL.CD_FILIAL = IN_CD_FILIAL
		AND TEMP_INFO_LINHA.CD_ARV_MERC_LINHA = B.CD_ARV_MERC_LINHA
		AND TEMP_INFO_LINHA.QTDE_ITENS >= A.QTDE_LEVE ;

	DECLARE CURSOR_LIN10 REFCURSOR;

	BEGIN OPEN CURSOR_LIN10 FOR 
	SELECT 
		TIL.QTDE_ITENS, 
		TIL.PERC_DESC, 
		TIL.CD_ARV_MERC_LINHA, 
		TIL.CD_TBL_DESC, 
		TIL.DS_TBL_DESC
	FROM
		TEMP_INFO_LINHA TIL
	WHERE
		TIL.PERC_DESC > 0;

	TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_LINHA TIL	WHERE TIL.PERC_DESC > 0);
	
	LOOP EXIT WHEN TMP_COUNT = 0;
	
		FETCH NEXT FROM CURSOR_LIN10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC,TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;

		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
		DECLARE CURSOR_LIN20 REFCURSOR;
		BEGIN OPEN CURSOR_LIN20 FOR 
		SELECT
			TII.CD_EMP,
			TII.CD_PROD,
			TII.CD_IT
		FROM
			TEMP_INFO_ITENS TII
		WHERE
			TII.CD_ARV_MERC_LINHA = TMP_CD_ARV_MERC
			AND SALDO > 0
		ORDER BY TII.CD_IT;

		FETCH FIRST FROM CURSOR_LIN20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;

		LOOP EXIT WHEN NOT FOUND;
			--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
			
			WHILE ( TMP_QTDE_ITENS ) > 0
				--DAR DESCONTOS 1 ITEM POR VEZ
				LOOP RAISE NOTICE 'UPDATE 18';

				UPDATE
					TEMP_INFO_ITENS TII
				SET
					SALDO = SALDO - 1,
					PERC_DESC = PERC_DESC + TMP_PERC_DESC,
					CD_TBL_DESC = TMP_CD_TBL_DESC,
					DS_TBL_DESC = TMP_DS_TBL_DESC
				WHERE
					TII.CD_EMP = TMP_CD_EMP
					AND TII.CD_PROD = TMP_CD_PROD
					AND TII.CD_IT = TMP_CD_IT;

				TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

				FETCH FROM CURSOR_LIN20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
			
				--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
				IF NOT FOUND THEN 
					FETCH FIRST FROM CURSOR_LIN20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
				END IF;
			END LOOP;

			MOVE LAST FROM CURSOR_LIN20;
			FETCH NEXT FROM CURSOR_LIN20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
			TMP_COUNT = TMP_COUNT -1;

		END LOOP;
		END;
	END LOOP;
	END;

END IF;




/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


-- D E S C O N T O    A C I M A


/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/
	
--ORGANIZA ITENS POR PRODUTO
	RAISE NOTICE 'INSERT PRODUTO';

	DELETE FROM TEMP_INFO_PROD;
	INSERT INTO TEMP_INFO_PROD 
	SELECT
	    SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		TEMP_INFO_ITENS.CD_PROD,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		TEMP_INFO_ITENS.CD_PROD;

--INICIA DESCONTO POR QUANTIDADE
 IF EXISTS ( SELECT 1 FROM TEMP_INFO_ITENS WHERE SALDO > 0 ) THEN
--INICIA DESCONTO POR QUANTIDADE
	IF EXISTS( SELECT 1 FROM TEMP_INFO_PROD ) THEN
	-------------------------------------------------------------------------------------------------------------------------------    
	--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------
	
	   UPDATE TEMP_INFO_PROD
	   	  SET PERC_DESC    = A.PERC_DESC,
	   		  --QTDE_ITENS = FLOOR(( TEMP_INFO_PROD.QTDE_ITENS / A.QTDE_ACIMA )) * A.QTDE_ACIMA,
	   		  CD_TBL_DESC  = A.CD_TBL_DESC,
	   		  DS_TBL_DESC  =  A.DS_TBL_DESC
	   	  FROM ( SELECT  B.PERC_DESC    AS PERC_DESC,
                         PER.QTDE_ACIMA  AS QTDE_ACIMA,
						 A.CD_TBL_DESC  AS CD_TBL_DESC,
						 A.DS_TBL_DESC  AS DS_TBL_DESC,
						 PER.CD_PROD 		AS CD_PROD
		           FROM EST_PROD_TBL_DESC A
						INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON A.CD_EMP = E.CD_EMP 
																 AND A.CD_TBL_DESC = E.CD_TBL_DESC 
						INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON E.CD_EMP      = FIL.CD_EMP 
																   AND E.CD_TBL_DESC = FIL.CD_TBL_DESC  
																   
						INNER JOIN EST_PROD_TBL_DESC_EST_PROD B   ON A.CD_EMP      = B.CD_EMP 
																 AND A.CD_TBL_DESC = B.CD_TBL_DESC 
						
						INNER JOIN RS_TAB_ATIVA_QTDE ON B.CD_EMP      = RS_TAB_ATIVA_QTDE.CD_EMP 
													AND B.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC 
													
					    INNER JOIN TEMP_INFO_PROD ON TEMP_INFO_PROD.CD_PROD     = B.CD_PROD
												 AND TEMP_INFO_PROD.QTDE_ITENS >= E.QTDE_ACIMA
												 
   					  	
						INNER JOIN (  SELECT MAX(AC.QTDE_ACIMA)  AS QTDE_ACIMA
											,MAX(PERC.PERC_DESC) AS PERC_DESC
						 			    	,TEMP_INFO_PROD.CD_PROD 
											,MAX(EST_PROD_TBL_DESC.DT_INI )DT_INI
						 			    FROM EST_PROD_TBL_DESC_EST_PROD PERC 
										  	 INNER JOIN RS_TAB_ATIVA_QTDE ON PERC.CD_TBL_DESC  = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
								 			 INNER JOIN TEMP_INFO_PROD ON TEMP_INFO_PROD.CD_PROD = PERC.CD_PROD
								 			 INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA AC on AC.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
								 			 									       and TEMP_INFO_PROD.QTDE_ITENS >= AC.QTDE_ACIMA
											 INNER JOIN EST_PROD_TBL_DESC ON 	EST_PROD_TBL_DESC.CD_TBL_DESC = PERC.CD_TBL_DESC 	
											 
								 	   GROUP BY   TEMP_INFO_PROD.CD_PROD 
						  			  ) PER ON PER.QTDE_ACIMA   = E.QTDE_ACIMA
						  			  	   AND PER.CD_PROD      = TEMP_INFO_PROD.CD_PROD
										   AND PER.PERC_DESC    = B.PERC_DESC
	             WHERE IN_CD_FILIAL = FIL.CD_FILIAL  
				 ORDER BY QTDE_ACIMA DESC ,PERC_DESC DESC, PER.DT_INI DESC --LIMIT 1 
					)  AS A 
	     WHERE TEMP_INFO_PROD.CD_PROD = A.CD_PROD
	       AND TEMP_INFO_PROD.QTDE_ITENS >= A.QTDE_ACIMA;				
	
	

--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_PROD10 REFCURSOR;
		BEGIN OPEN CURSOR_PROD10 FOR 
		SELECT
			TIF.QTDE_ITENS,
			TIF.PERC_DESC,
			TIF.CD_PROD,
			TIF.CD_TBL_DESC,
			TIF.DS_TBL_DESC
		FROM
			TEMP_INFO_PROD TIF
		WHERE
			TIF.PERC_DESC > 0;
		
		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_PROD TIF WHERE TIF.PERC_DESC > 0);

		LOOP EXIT WHEN TMP_COUNT = 0;
			FETCH FROM CURSOR_PROD10 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		 
		
		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_PROD20 REFCURSOR;
			BEGIN OPEN CURSOR_PROD20 FOR SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				TII.CD_PROD = TMP_CD_ARV_MERC
				AND SALDO > 0
			ORDER BY TII.CD_IT;

			FETCH FIRST FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
										
			LOOP EXIT WHEN NOT FOUND;

				--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
				WHILE ( TMP_QTDE_ITENS ) > 0 
				--CONTINUAR ENQUANTO EXISTIR ALGUM PRODUTO SEM DESCONTO
					LOOP RAISE NOTICE 'CURSOR_PROD20';
			
					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = TII.PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP = TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT = TMP_CD_IT;
			
					TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;
			
					FETCH IN CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN 
						FETCH FIRST FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
					END IF;
				END LOOP;	
				
				MOVE LAST FROM CURSOR_PROD20;
				FETCH NEXT FROM CURSOR_PROD20 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;
			END LOOP;
			END;
		END LOOP;
		END;
	END IF;
/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS POR FAMILIA
/***************************************************************************************************************************************************/
	DELETE FROM TEMP_INFO_FAMILIA;
	RAISE NOTICE 'INSERT 19';
	INSERT INTO TEMP_INFO_FAMILIA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_FAMILIA,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
	TEMP_INFO_ITENS
	WHERE
	SALDO > 0
	GROUP BY
	CD_ARV_MERC_FAMILIA;
	--VERIFICA NECESSIDADE DE CONSULTAS
	 IF EXISTS( SELECT 1 FROM TEMP_INFO_FAMILIA ) THEN
		-------------------------------------------------------------------------------------------------------------------------------    
		--CONSULTANDO AS TABELAS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
		-------------------------------------------------------------------------------------------------------------------------------    
		RAISE NOTICE 'UPDATE 20';

	
	 UPDATE 
			TEMP_INFO_FAMILIA
		SET
			PERC_DESC = B.PERC_DESC,
			-- QTDE_ITENS = FLOOR(( TEMP_INFO_FAMILIA.QTDE_ITENS / E.QTDE_ACIMA )) * E.QTDE_ACIMA,
			CD_TBL_DESC = A.CD_TBL_DESC,
			DS_TBL_DESC = A.DS_TBL_DESC
		FROM EST_PROD_TBL_DESC A
			 INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON A.CD_EMP			= E.CD_EMP
													  AND A.CD_TBL_DESC		= E.CD_TBL_DESC
			 INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_FAMILIA B ON A.CD_EMP		= B.CD_EMP
																AND A.CD_TBL_DESC	= B.CD_TBL_DESC
			 INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON B.CD_EMP	 	= FIL.CD_EMP
														AND B.CD_TBL_DESC	= FIL.CD_TBL_DESC
			 INNER JOIN TEMP_INFO_ITENS TII ON B.CD_EMP				 = TII.CD_EMP
										   AND B.CD_ARV_MERC_FAMILIA = TII.CD_ARV_MERC_FAMILIA
			 INNER JOIN RS_TAB_ATIVA_QTDE ON A.CD_EMP		= RS_TAB_ATIVA_QTDE.CD_EMP
										 AND B.CD_TBL_DESC	= RS_TAB_ATIVA_QTDE.CD_TBL_DESC
			 INNER JOIN   ( SELECT MAX(AC.QTDE_ACIMA) AS QTDE_ACIMA
								  ,MAX(PERC.PERC_DESC) AS PERC_DESC
								  ,TEMP_INFO_FAMILIA.CD_ARV_MERC_FAMILIA
								  ,MAX(EST_PROD_TBL_DESC.DT_INI) DT_INI
							  FROM EST_PROD_TBL_DESC_EST_ARV_MERC_FAMILIA PERC
							       INNER JOIN RS_TAB_ATIVA_QTDE ON PERC.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
							       INNER JOIN TEMP_INFO_FAMILIA ON TEMP_INFO_FAMILIA.CD_ARV_MERC_FAMILIA = PERC.CD_ARV_MERC_FAMILIA
							       INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA AC ON AC.CD_TBL_DESC					= RS_TAB_ATIVA_QTDE.CD_TBL_DESC
																			 AND TEMP_INFO_FAMILIA.QTDE_ITENS  >= AC.QTDE_ACIMA
								   INNER JOIN EST_PROD_TBL_DESC ON EST_PROD_TBL_DESC.CD_TBL_DESC = PERC.CD_TBL_DESC
							 GROUP BY TEMP_INFO_FAMILIA.CD_ARV_MERC_FAMILIA ) FAM ON FAM.QTDE_ACIMA = E.QTDE_ACIMA 
				 																 AND FAM.PERC_DESC  = B.PERC_DESC
																				 AND FAM.CD_ARV_MERC_FAMILIA = B.CD_ARV_MERC_FAMILIA 											
	   WHERE IN_CD_FILIAL = FIL.CD_FILIAL
		 AND TEMP_INFO_FAMILIA.QTDE_ITENS >= E.QTDE_ACIMA
		 AND TEMP_INFO_FAMILIA.CD_ARV_MERC_FAMILIA = B.CD_ARV_MERC_FAMILIA;


		--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_FAM1 REFCURSOR;
		BEGIN OPEN CURSOR_FAM1 FOR 
		SELECT
			TIF.QTDE_ITENS,
			TIF.PERC_DESC,
			TIF.CD_ARV_MERC_FAMILIA,
			TIF.CD_TBL_DESC,
			TIF.DS_TBL_DESC
		FROM
			TEMP_INFO_FAMILIA TIF
		WHERE
			TIF.PERC_DESC > 0;

		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_FAMILIA TIF	WHERE TIF.PERC_DESC > 0);
		
		LOOP EXIT WHEN TMP_COUNT = 0;
		
			FETCH NEXT FROM CURSOR_FAM1 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;

			--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_FAM2 REFCURSOR;
			BEGIN OPEN CURSOR_FAM2 FOR 
			SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				CD_ARV_MERC_FAMILIA = TMP_CD_ARV_MERC
				AND SALDO > 0;

			FETCH FIRST FROM CURSOR_FAM2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

			LOOP EXIT WHEN NOT FOUND;
			--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
			 
				WHILE ( TMP_QTDE_ITENS ) > 0
					--CONTINUAR ENQUANTO EXISTIR ALGUM PRODUTO SEM DESCONTO
				LOOP RAISE NOTICE 'UPDATE 21';

					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = TII.PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP = TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT = TMP_CD_IT;

					TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

					FETCH NEXT FROM CURSOR_FAM2 INTO TMP_CD_EMP,TMP_CD_PROD,TMP_CD_IT;
				
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN 
						FETCH FIRST FROM CURSOR_FAM2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					END IF;
				END LOOP;
				MOVE LAST FROM CURSOR_FAM2;
				FETCH NEXT FROM CURSOR_FAM2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;
				
		END LOOP;
		END;
	END LOOP;
	END;
END IF;



/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR MARCA
/***************************************************************************************************************************************************/
	RAISE NOTICE 'INSERT 22';
	DELETE
	FROM
		TEMP_INFO_MARCA;

	INSERT INTO TEMP_INFO_MARCA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_MC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_MC;

	IF EXISTS( SELECT 1 FROM TEMP_INFO_MARCA ) THEN
-------------------------------------------------------------------------------------------------------------------------------        
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
-------------------------------------------------------------------------------------------------------------------------------    
		RAISE NOTICE 'UPDATE 23';
		UPDATE
			TEMP_INFO_MARCA
		SET
			PERC_DESC = B.PERC_DESC,
		--	QTDE_ITENS = FLOOR(( TEMP_INFO_MARCA.QTDE_ITENS / E.QTDE_ACIMA )) * E.QTDE_ACIMA,
			CD_TBL_DESC = A.CD_TBL_DESC,
			DS_TBL_DESC = A.DS_TBL_DESC
		FROM
			EST_PROD_TBL_DESC A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON
			A.CD_EMP = E.CD_EMP
			AND A.CD_TBL_DESC = E.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_EST_MC B ON
			A.CD_EMP = B.CD_EMP
			AND A.CD_TBL_DESC = B.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON
			B.CD_EMP = FIL.CD_EMP
			AND B.CD_TBL_DESC = FIL.CD_TBL_DESC
			INNER JOIN TEMP_INFO_ITENS TIF ON
			B.CD_EMP = TIF.CD_EMP
			AND B.CD_MC = TIF.CD_MC
			INNER JOIN RS_TAB_ATIVA_QTDE ON
			A.CD_EMP = RS_TAB_ATIVA_QTDE.CD_EMP
			AND B.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
			INNER JOIN TEMP_INFO_MARCA TIM ON
			TIM.CD_MC = B.CD_MC
			WHERE
			IN_CD_FILIAL = FIL.CD_FILIAL
			AND TEMP_INFO_MARCA.QTDE_ITENS >= E.QTDE_ACIMA
			AND TIM.CD_MC = B.CD_MC;

		--CURSOR DE LEITURA DE DESCONTOS
		DECLARE CURSOR_MC1 REFCURSOR;
		BEGIN OPEN CURSOR_MC1 FOR 
		SELECT
			TIM.QTDE_ITENS,
			TIM.PERC_DESC,
			TIM.CD_MC,
			TIM.CD_TBL_DESC,
			TIM.DS_TBL_DESC
		FROM
			TEMP_INFO_MARCA TIM
		WHERE
			TIM.PERC_DESC > 0;

		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_MARCA TIM WHERE TIM.PERC_DESC > 0);
		
		LOOP EXIT WHEN TMP_COUNT = 0;
		
			FETCH NEXT FROM CURSOR_MC1 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		
			--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_MC2 REFCURSOR;
			BEGIN OPEN CURSOR_MC2 FOR 
			SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				TII.CD_MC = TMP_CD_ARV_MERC
				AND SALDO > 0;

		FETCH FIRST FROM CURSOR_MC2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

		LOOP EXIT WHEN NOT FOUND;
		--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
			WHILE ( TMP_QTDE_ITENS ) > 0
				--DAR DESCONTOS 1 ITEM POR VEZ
			LOOP RAISE NOTICE 'UPDATE 24';

				UPDATE TEMP_INFO_ITENS TII
				SET
					SALDO = SALDO - 1,
					PERC_DESC = PERC_DESC + TMP_PERC_DESC,
					CD_TBL_DESC = TMP_CD_TBL_DESC,
					DS_TBL_DESC = TMP_DS_TBL_DESC
				WHERE
					TII.CD_EMP = TMP_CD_EMP
					AND TII.CD_PROD = TMP_CD_PROD
					AND TII.CD_IT = TMP_CD_IT;

				 TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

				FETCH NEXT FROM CURSOR_MC2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
				IF NOT FOUND THEN 
					FETCH FIRST FROM CURSOR_MC2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				END IF;
			END LOOP;
			MOVE LAST FROM CURSOR_MC2;
			FETCH NEXT FROM CURSOR_MC2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
			TMP_COUNT = TMP_COUNT -1;
		END LOOP;
		END;
	END LOOP;
	END;
END IF;


/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR FABRICANTE
/***************************************************************************************************************************************************/

	RAISE NOTICE 'INSERT 25';

	DELETE FROM TEMP_INFO_FABRIC;

	INSERT INTO TEMP_INFO_FABRIC 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_FABRIC,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_FABRIC;

	IF EXISTS( SELECT 1 FROM TEMP_INFO_FABRIC ) THEN
-------------------------------------------------------------------------------------------------------------------------------    
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
-------------------------------------------------------------------------------------------------------------------------------  
	RAISE NOTICE 'UPDATE 26';

	UPDATE
		TEMP_INFO_FABRIC
	SET
		PERC_DESC 	= B.PERC_DESC,
	--	QTDE_ITENS 	= FLOOR(( TEMP_INFO_FABRIC.QTDE_ITENS / E.QTDE_ACIMA )) * E.QTDE_ACIMA,
		CD_TBL_DESC = A.CD_TBL_DESC,
		DS_TBL_DESC = A.DS_TBL_DESC
	FROM
		EST_PROD_TBL_DESC A
		INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON
		A.CD_EMP = E.CD_EMP
		AND A.CD_TBL_DESC = E.CD_TBL_DESC
		INNER JOIN EST_PROD_TBL_DESC_EST_PROD_FABRIC B ON
		A.CD_EMP = B.CD_EMP
		AND A.CD_TBL_DESC = B.CD_TBL_DESC
		INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON
		B.CD_EMP = FIL.CD_EMP
		AND B.CD_TBL_DESC = FIL.CD_TBL_DESC
		INNER JOIN TEMP_INFO_ITENS TIF ON
		B.CD_EMP = TIF.CD_EMP
		AND B.CD_FABRIC = TIF.CD_FABRIC
		INNER JOIN RS_TAB_ATIVA_QTDE ON
		A.CD_EMP = RS_TAB_ATIVA_QTDE.CD_EMP
		AND B.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
	WHERE
		IN_CD_FILIAL = FIL.CD_FILIAL
		AND TEMP_INFO_FABRIC.QTDE_ITENS >= E.QTDE_ACIMA
		AND TEMP_INFO_FABRIC.CD_FABRIC = B.CD_FABRIC;


	--CURSOR DE LEITURA DE DESCONTOS
	DECLARE CURSOR_FAB1 REFCURSOR;
	BEGIN OPEN CURSOR_FAB1 FOR 
	SELECT 
		TI.QTDE_ITENS, TI.PERC_DESC, TI.CD_FABRIC, TI.CD_TBL_DESC, TI.PERC_DESC
	FROM
		TEMP_INFO_FABRIC TI
	WHERE	 TI.PERC_DESC > 0;

	TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_FABRIC TI WHERE TI.PERC_DESC > 0);
	
	LOOP EXIT WHEN TMP_COUNT = 0;
	
		FETCH NEXT FROM CURSOR_FAB1 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;

		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
		DECLARE CURSOR_FAB2 REFCURSOR;
		BEGIN OPEN CURSOR_FAB2 FOR 
		SELECT
			TII.CD_EMP,
			TII.CD_PROD,
			TII.CD_IT
		FROM
			TEMP_INFO_ITENS TII
		WHERE
			TII.CD_FABRIC = TMP_CD_ARV_MERC
			AND SALDO > 0;

			FETCH FIRST FROM CURSOR_FAB2 INTO TMP_CD_EMP,TMP_CD_PROD,TMP_CD_IT; 
			
			LOOP EXIT WHEN NOT FOUND;
				--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
				WHILE ( TMP_QTDE_ITENS ) > 0
					--DAR DESCONTOS 1 ITEM POR VEZ
				LOOP RAISE NOTICE 'INSERT 27';

					UPDATE
						TEMP_INFO_ITENS TII
					SET
						SALDO = SALDO - 1,
						PERC_DESC = PERC_DESC + TMP_PERC_DESC,
						CD_TBL_DESC = TMP_CD_TBL_DESC,
						DS_TBL_DESC = TMP_DS_TBL_DESC
					WHERE
						TII.CD_EMP = TMP_CD_EMP
						AND TII.CD_PROD = TMP_CD_PROD
						AND TII.CD_IT = TMP_CD_IT;

					TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

					FETCH NEXT FROM CURSOR_FAB2 INTO TMP_CD_EMP,TMP_CD_PROD,TMP_CD_IT;
					--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
					IF NOT FOUND THEN 
						FETCH FIRST FROM CURSOR_FAB2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
					END IF;		
				END LOOP;
				
				MOVE LAST FROM CURSOR_FAB2;
				FETCH NEXT FROM CURSOR_FAB2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				TMP_COUNT = TMP_COUNT -1;

			END LOOP;
			END;
		END LOOP;
		END;
	END IF;



/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR CATEGORIAS
/***************************************************************************************************************************************************/
 
	RAISE NOTICE 'INSERT 28';

	DELETE
	FROM
		TEMP_INFO_CATEGORIA;

	INSERT INTO TEMP_INFO_CATEGORIA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_CATEG,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_ARV_MERC_CATEG;

	IF EXISTS( SELECT 1 FROM TEMP_INFO_CATEGORIA ) THEN
------------------------------------------------------------------------------------------------------------------------------    
--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS        
-------------------------------------------------------------------------------------------------------------------------------  
		RAISE NOTICE 'UPDATE 29';

		UPDATE
			TEMP_INFO_CATEGORIA
		SET
			PERC_DESC = B.PERC_DESC,
		--	QTDE_ITENS = FLOOR(( TEMP_INFO_CATEGORIA.QTDE_ITENS / E.QTDE_ACIMA )) * E.QTDE_ACIMA,
			CD_TBL_DESC = A.CD_TBL_DESC,
			DS_TBL_DESC = A.DS_TBL_DESC
		FROM
			EST_PROD_TBL_DESC A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON
			A.CD_EMP = E.CD_EMP
			AND A.CD_TBL_DESC = E.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_CATEGORIA B ON
			A.CD_EMP = B.CD_EMP
			AND A.CD_TBL_DESC = B.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON
			B.CD_EMP = FIL.CD_EMP
			AND B.CD_TBL_DESC = FIL.CD_TBL_DESC
			INNER JOIN TEMP_INFO_ITENS TIF ON
			B.CD_EMP = TIF.CD_EMP
			AND B.CD_ARV_MERC_CATEG = TIF.CD_ARV_MERC_CATEG
			INNER JOIN RS_TAB_ATIVA_QTDE ON
			A.CD_EMP = RS_TAB_ATIVA_QTDE.CD_EMP
			AND B.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
		WHERE
			IN_CD_FILIAL = FIL.CD_FILIAL
			AND TEMP_INFO_CATEGORIA.QTDE_ITENS >= E.QTDE_ACIMA
			AND TEMP_INFO_CATEGORIA.CD_ARV_MERC_CATEG = B.CD_ARV_MERC_CATEG;

		DECLARE CURSOR_CAT1 REFCURSOR;
		BEGIN OPEN CURSOR_CAT1 FOR 
		SELECT
			TIC.QTDE_ITENS,			TIC.PERC_DESC,			TIC.CD_ARV_MERC_CATEG,TIC.CD_TBL_DESC,
			TIC.DS_TBL_DESC
		FROM
			TEMP_INFO_CATEGORIA TIC
		WHERE
			TIC.PERC_DESC > 0;

		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_CATEGORIA TIC WHERE TIC.PERC_DESC > 0);
		
		LOOP EXIT WHEN TMP_COUNT = 0;
		
			FETCH NEXT FROM CURSOR_CAT1 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
			--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			
			DECLARE CURSOR_CAT2 REFCURSOR;
			BEGIN OPEN CURSOR_CAT2 FOR 
			SELECT
				TII.CD_EMP,
				TII.CD_PROD,
				TII.CD_IT
			FROM
				TEMP_INFO_ITENS TII
			WHERE
				TII.CD_ARV_MERC_CATEG = TMP_CD_ARV_MERC
				AND SALDO > 0;

			FETCH FIRST FROM CURSOR_CAT2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

			LOOP EXIT WHEN NOT FOUND;

			--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
			WHILE ( TMP_QTDE_ITENS ) > 0
			--DAR DESCONTOS 1 ITEM POR VEZ
				LOOP RAISE NOTICE 'UPDATE 30';

				UPDATE
					TEMP_INFO_ITENS TII
				SET
					SALDO = SALDO - 1,
					PERC_DESC = PERC_DESC + TMP_PERC_DESC,
					CD_TBL_DESC = TMP_CD_TBL_DESC,
					DS_TBL_DESC = TMP_DS_TBL_DESC
				WHERE
					TII.CD_EMP = TMP_CD_EMP
					AND TII.CD_PROD = TMP_CD_PROD
					AND TII.CD_IT = TMP_CD_IT;

				TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

				FETCH NEXT FROM CURSOR_CAT2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

				--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
				IF NOT FOUND THEN 
					FETCH FIRST FROM CURSOR_CAT2 INTO TMP_CD_EMP, TMP_CD_PROD,TMP_CD_IT;
				END IF;
			END LOOP;

			MOVE LAST FROM CURSOR_CAT2;
			FETCH NEXT FROM CURSOR_CAT2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
			TMP_COUNT = TMP_COUNT -1;

		END LOOP;
		END;
	END LOOP;
	END;
END IF;



/***************************************************************************************************************************************************/
/***************************************************************************************************************************************************/


/***************************************************************************************************************************************************/
--ORGANIZA ITENS RESTANTES POR LINHAS
/***************************************************************************************************************************************************/

	RAISE NOTICE 'INSERT 31';
	DELETE FROM TEMP_INFO_LINHA;
	
	INSERT INTO TEMP_INFO_LINHA 
	SELECT
		SUM( SALDO ) AS QTDE_ITENS,
		0 AS PERC_DESC,
		CD_ARV_MERC_LINHA,
		0 AS CD_TBL_DESC,
		'' AS DS_TBL_DESC
	FROM
		TEMP_INFO_ITENS
	WHERE
		SALDO > 0
	GROUP BY
		CD_ARV_MERC_LINHA;

	 IF EXISTS( SELECT 1 FROM TEMP_INFO_LINHA ) THEN
	-------------------------------------------------------------------------------------------------------------------------------    
	--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
	-------------------------------------------------------------------------------------------------------------------------------   
		RAISE NOTICE 'UPDATE 32';

		UPDATE
			TEMP_INFO_LINHA
		SET
			PERC_DESC = B.PERC_DESC,
		--	QTDE_ITENS = FLOOR(( TEMP_INFO_LINHA.QTDE_ITENS / E.QTDE_ACIMA )) * E.QTDE_ACIMA,
			CD_TBL_DESC = A.CD_TBL_DESC,
			DS_TBL_DESC = A.DS_TBL_DESC
		FROM
			EST_PROD_TBL_DESC A
			INNER JOIN EST_PROD_TBL_DESC_QTDE_ACIMA E ON
			A.CD_EMP = E.CD_EMP
			AND A.CD_TBL_DESC = E.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_LINHA B ON
			A.CD_EMP = B.CD_EMP
			AND A.CD_TBL_DESC = B.CD_TBL_DESC
			INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL FIL ON
			B.CD_EMP = FIL.CD_EMP
			AND B.CD_TBL_DESC = FIL.CD_TBL_DESC
			INNER JOIN TEMP_INFO_ITENS TIF ON
			B.CD_EMP = TIF.CD_EMP
			AND B.CD_ARV_MERC_LINHA = TIF.CD_ARV_MERC_LINHA
			INNER JOIN RS_TAB_ATIVA_QTDE ON
			A.CD_EMP = RS_TAB_ATIVA_QTDE.CD_EMP
			AND B.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
		WHERE
			IN_CD_FILIAL = FIL.CD_FILIAL
			AND TEMP_INFO_LINHA.QTDE_ITENS >= E.QTDE_ACIMA
			AND TEMP_INFO_LINHA.CD_ARV_MERC_LINHA = B.CD_ARV_MERC_LINHA;

		DECLARE CURSOR_LIN1 REFCURSOR;
		BEGIN OPEN CURSOR_LIN1 FOR 
		SELECT 
			TIL.QTDE_ITENS, 
			TIL.PERC_DESC,
			TIL.CD_ARV_MERC_LINHA,
			TIL.CD_TBL_DESC,
			TIL.DS_TBL_DESC
		FROM
			TEMP_INFO_LINHA TIL
		WHERE
			TIL.PERC_DESC > 0;

		TMP_COUNT = (SELECT COUNT(1) FROM TEMP_INFO_LINHA TIL WHERE TIL.PERC_DESC > 0);
		
		LOOP EXIT WHEN TMP_COUNT = 0;
		
			FETCH NEXT FROM CURSOR_LIN1 INTO TMP_QTDE_ITENS, TMP_PERC_DESC, TMP_CD_ARV_MERC, TMP_CD_TBL_DESC, TMP_DS_TBL_DESC;
		
		--CURSOR DE APLICAÇÃO DESCONTOS SOBRE ITENS
			DECLARE CURSOR_LIN2 REFCURSOR;
			BEGIN OPEN CURSOR_LIN2 FOR 
				SELECT
					TII.CD_EMP,
					TII.CD_PROD,
					TII.CD_IT
				FROM
					TEMP_INFO_ITENS TII
				WHERE
					TII.CD_ARV_MERC_LINHA = TMP_CD_ARV_MERC
					AND SALDO > 0;


			FETCH FIRST FROM CURSOR_LIN2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

			LOOP EXIT WHEN NOT FOUND;
			--FINALIZAR CASO NÃO EXISTA MAIS DESCONTOS A SER APLICADOS
	 
			WHILE ( TMP_QTDE_ITENS ) > 0
				--DAR DESCONTOS 1 ITEM POR VEZ
				LOOP RAISE NOTICE 'UPDATE 33';

				UPDATE
					TEMP_INFO_ITENS TII
				SET
					SALDO = SALDO - 1,
					PERC_DESC = PERC_DESC + TMP_PERC_DESC,
					CD_TBL_DESC = TMP_CD_TBL_DESC,
					DS_TBL_DESC = TMP_DS_TBL_DESC
				WHERE
					TII.CD_EMP = TMP_CD_EMP
					AND TII.CD_PROD = TMP_CD_PROD
					AND TII.CD_IT = TMP_CD_IT;

				TMP_QTDE_ITENS = TMP_QTDE_ITENS - 1;

				FETCH NEXT FROM CURSOR_LIN2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;

				--RETORNAR AO PRIMEIRO REGISTRO PARA CONTINUAR A DAR DESCONTOS CASO AINDA EXISTAM ITEMS A RECEBER DESCONTO
				IF NOT FOUND THEN 
					FETCH FIRST	FROM CURSOR_LIN2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
				END IF;
			END LOOP;
			MOVE LAST FROM CURSOR_LIN2;
			FETCH NEXT	FROM CURSOR_LIN2 INTO TMP_CD_EMP, TMP_CD_PROD, TMP_CD_IT;
			TMP_COUNT = TMP_COUNT -1;
			
			END LOOP;
			END;
		END LOOP;
		END;
	END IF;
END IF;


/******************************************************************************************************************************************************/
/******************************************************************************************************************************************************/
/******************************************************************************************************************************************************/
--RATEIA OS DESCONTOS QUE FORAM SOMADOS
/******************************************************************************************************************************************************/
	RAISE NOTICE 'RATEIA OS DESCONTOS QUE FORAM SOMADOS - LINHA 1800';

	UPDATE TEMP_INFO_ITENS 
	SET
		PERC_DESC = ( TEMP_INFO_ITENS.PERC_DESC / ( TEMP_INFO_ITENS.QT_IT - TEMP_INFO_ITENS.SALDO ))
	WHERE
		TEMP_INFO_ITENS.PERC_DESC > 0 
		AND ( TEMP_INFO_ITENS.QT_IT - TEMP_INFO_ITENS.SALDO )>0;
	
	
	
	
	
	--CAPTURANDO % DESCONTO DE OFERTA 
 	UPDATE TEMP_INFO_ITENS  
	   SET PERC_DESC_OFERTA =  ROUND( ((1 - TEMP_INFO_ITENS.VLR_OFERTA / TEMP_INFO_ITENS.VLR_ITEM) * 100)::NUMERIC , 4)
	 WHERE VLR_OFERTA>0 ;
--	   AND TEMP_INFO_ITENS.AGREGACAO = 0;

-------------------------------------------------------------------------------------------------------------------------------
-- CAPTURA AGREGACAO E TP_DESCONTO DO DESCONTO LEV_PAG 	
-------------------------------------------------------------------------------------------------------------------------------		
	
	UPDATE TEMP_INFO_ITENS
	   SET AGREGACAO      = EST_PROD_TBL_DESC_QTDE.AGREGACAO,
		   CD_TP_DESCONTO = EST_PROD_TBL_DESC_QTDE.cd_tp_desconto
	  FROM EST_PROD_TBL_DESC_QTDE
		   INNER JOIN RS_TAB_QTDE_ATIVA ON RS_TAB_QTDE_ATIVA.CD_TBL_DESC_QTDE = EST_PROD_TBL_DESC_QTDE.CD_TBL_DESC_QTDE
	 WHERE TEMP_INFO_ITENS.CD_TBL_DESC = EST_PROD_TBL_DESC_QTDE.CD_TBL_DESC_QTDE
	   AND TEMP_INFO_ITENS.CD_EMP = EST_PROD_TBL_DESC_QTDE.CD_EMP ;
	
	
	--SE FOR AGREGACAO DE DESCONTO, FAZ SOBRE O VALOR LIQUIDO/COM DESCONTOS...
	UPDATE  TEMP_INFO_ITENS SET  VLR_ITEM = VLR_ITEM_LIQ WHERE 	TEMP_INFO_ITENS.AGREGACAO = 1 AND TEMP_INFO_ITENS.cd_tp_desconto = 24 ;
	
	DELETE FROM TEMP_INFO_ITENS WHERE TEMP_INFO_ITENS.QT_IT=0;
	--DELETE FROM TEMP_INFO_ITENS WHERE PERC_DESC=0;
	
	


	
-------------------------------------------------------------------------------------------------------------------------------
-- CAPTURA ABREGACAO E MULTIPLO DO DESCONTO QTDE
-------------------------------------------------------------------------------------------------------------------------------	
	UPDATE TEMP_INFO_ITENS
	   SET
		   AGREGACAO      = EST_PROD_TBL_DESC.flag_agregar_desc_qtde_aos_descontos_existentes,
		   CD_TP_DESCONTO = EST_PROD_TBL_DESC.cd_tp_desconto
	 FROM EST_PROD_TBL_DESC
		  INNER JOIN RS_TAB_ATIVA_QTDE ON  RS_TAB_ATIVA_QTDE.CD_TBL_DESC = EST_PROD_TBL_DESC.CD_TBL_DESC
	WHERE TEMP_INFO_ITENS.CD_TBL_DESC = EST_PROD_TBL_DESC.CD_TBL_DESC
	  AND TEMP_INFO_ITENS.CD_EMP      = EST_PROD_TBL_DESC.CD_EMP 
	  and EST_PROD_TBL_DESC.CD_TP_DESCONTO = 14 ;
	
	
		/*TMP_QTDE_MULT = ( SELECT SUM(TEMP_INFO_ITENS.QT_IT)  QTde, 
								TEMP_INFO_ITENS.CD_TBL_DESC
						   FROM TEMP_INFO_ITENS 
								JOIN RS_TAB_ATIVA_QTDE ON  TEMP_INFO_ITENS.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
								group by TEMP_INFO_ITENS.CD_TBL_DESC
						 );
						 */
	-- CALCULA PERC_DESC SE FOR MULTIPLO 	
	UPDATE TEMP_INFO_ITENS
	   SET PERC_DESC  =(((CAST(tblQtd.Qtde AS INTEGER ) - (CAST(tblQtd.Qtde AS INTEGER ) % EST_PROD_TBL_DESC_QTDE_ACIMA.QTDE_ACIMA))) * TEMP_INFO_ITENS.PERC_DESC) / (CAST(tblQtd.Qtde AS INTEGER ))
	  FROM EST_PROD_TBL_DESC_QTDE_ACIMA 
	      JOIN EST_PROD_TBL_DESC ON EST_PROD_TBL_DESC.CD_TBL_DESC = EST_PROD_TBL_DESC_QTDE_ACIMA.CD_TBL_DESC
		  JOIN RS_TAB_ATIVA_QTDE ON  RS_TAB_ATIVA_QTDE.CD_TBL_DESC = EST_PROD_TBL_DESC.CD_TBL_DESC
		  join ( SELECT SUM(TEMP_INFO_ITENS.QT_IT)  Qtde, 
								TEMP_INFO_ITENS.CD_TBL_DESC
						   FROM TEMP_INFO_ITENS 
								JOIN RS_TAB_ATIVA_QTDE ON  TEMP_INFO_ITENS.CD_TBL_DESC = RS_TAB_ATIVA_QTDE.CD_TBL_DESC
								group by TEMP_INFO_ITENS.CD_TBL_DESC
						 ) tblQtd on 
						  RS_TAB_ATIVA_QTDE.CD_TBL_DESC = tblQtd.CD_TBL_DESC
						 
	 WHERE TEMP_INFO_ITENS.CD_TBL_DESC = EST_PROD_TBL_DESC_QTDE_ACIMA.CD_TBL_DESC
	   AND TEMP_INFO_ITENS.CD_EMP      = EST_PROD_TBL_DESC_QTDE_ACIMA.CD_EMP 
	   AND EST_PROD_TBL_DESC.FLAG_APLICA_DESCONTO_QTDE_MULTIPLO = 1 ;
	
	
	
	--SE FOR AGREGACAO DE DESCONTO, FAZ SOBRE O VALOR LIQUIDO/COM DESCONTOS...
	UPDATE  TEMP_INFO_ITENS SET  VLR_ITEM = VLR_ITEM_LIQ WHERE 	TEMP_INFO_ITENS.AGREGACAO = 1 AND  TEMP_INFO_ITENS.CD_TP_DESCONTO = 14;
	

 
-------------------------------------------------------------------------------------------------------------------------------
-- OFERTA GERAL
-------------------------------------------------------------------------------------------------------------------------------		

	--SE EXISTIR OFERTA E AGREGAÇÃO FAZ A AGREGACAO SOBRE VALOR DA OFERTA 
	UPDATE TEMP_INFO_ITENS  SET VLR_ITEM = VLR_OFERTA  WHERE VLR_OFERTA >0 AND TEMP_INFO_ITENS.AGREGACAO = 1 AND VLR_OFERTA < VLR_ITEM_LIQ  ;
	
	   
	   
	--VERIFICANDO QUAL MELHOR DESCONTO 
	UPDATE TEMP_INFO_ITENS  
	   SET PERC_DESC =  CASE WHEN PERC_DESC_OFERTA > PERC_DESC THEN PERC_DESC_OFERTA
							 ELSE PERC_DESC
						 END 								
	 WHERE VLR_OFERTA >0 
	   AND TEMP_INFO_ITENS.AGREGACAO = 0
	   AND TEMP_INFO_ITENS.PERC_DESC > 0;   
	   
	
	
	DELETE FROM TEMP_INFO_ITENS WHERE TEMP_INFO_ITENS.QT_IT=0  AND  TEMP_INFO_ITENS.CD_TP_DESCONTO = 14;

-------------------------------------------------------------------------------------------------------------------------------
-- Se não tiver desconto LEV_PAG e QTDE, herda o capturado na rotina anterior. 
-------------------------------------------------------------------------------------------------------------------------------		
 	
	UPDATE TEMP_INFO_ITENS SET VLR_ITEM =  VLR_ITEM_LIQ WHERE VLR_ITEM_LIQ > 0 AND PERC_DESC = 0 AND TEMP_INFO_ITENS.AGREGACAO = 0;
 
-------------------------------------------------------------------------------------------------------------------------------
-- LIMITE DE VENDA 
-------------------------------------------------------------------------------------------------------------------------------	
		
	if exists (SELECT * FROM TEMP_INFO_ITENS IT WHERE IT.QTDE_LIMITE_VENDA > 0  AND IT.QT_IT > IT.QTDE_LIMITE_VENDA  LIMIT 1 ) THEN 
		RAISE EXCEPTION '   Atenção! Existe um produto com a quantidade acima do permitido na venda       ';
	  end if ; 
	


/******************************************************************************************************************************************************/
/******************************************************************************************************************************************************/
-------------------------------------------------------------------------------------------------------------------------------
-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
-------------------------------------------------------------------------------------------------------------------------------
 	 RAISE NOTICE 'RETORNO FINAL';
				
	RETURN QUERY  
		
		SELECT 
			TII.VERSAO,
	        CASE WHEN TII.CD_TP_DESCONTO = 0 or TII.CD_TP_DESCONTO is null  THEN CP.CD_TP_DESCONTO 
			     ELSE TII.CD_TP_DESCONTO 
			 END,	
			COALESCE(TII.CD_PROD, CP.CD_PROD) CD_PROD,
			
			/*
			CASE WHEN TII.CD_TBL_DESC = 0 or TII.CD_TBL_DESC is null  THEN CP.CD_CAMPANHA_ADIC 
			     ELSE TII.CD_TBL_DESC 
			 END,
			*/
			
			CASE WHEN CP.CD_CAMPANHA_ADIC = 0 OR CP.CD_CAMPANHA_ADIC IS NULL THEN 
				TII.CD_TBL_DESC
			ELSE
				CP.CD_CAMPANHA_ADIC
			END,
			
			CASE WHEN TII.DS_TBL_DESC = '' or TII.DS_TBL_DESC is null THEN CP.DS_CAMPANHA_ADIC 
			     ELSE TII.DS_TBL_DESC 
			 END,
			COALESCE(TII.QT_IT,0) + COALESCE(CP.QT_IT,0) 	QT_IT , 				 
			(((COALESCE(TII.VLR_ITEM,0) * ( CAST (COALESCE( TII.PERC_DESC, 0) AS FLOAT) / 100)) * COALESCE(TII.QT_IT,0)   ) + COALESCE(CP.VLR_ITEM-(CP.VLR_VENDA),0))
				/ (COALESCE(TII.QT_IT,0) + COALESCE(CP.QT_IT,0))	AS VLR_DESC_ITEM,
			(( CAST ( COALESCE(TII.QT_IT,0) AS FLOAT ) * COALESCE(TII.VLR_ITEM,0) ) *( CAST ( COALESCE( TII.PERC_DESC, 0 ) AS FLOAT ) / 100 )) 
			+  COALESCE(CP.VLR_DESCONTO,0 ) 	    AS VLR_DESCONTO,  
			COALESCE(TII.VLR_ITEM,CP.VLR_ITEM)    	AS VLR_ITEM,
			COALESCE(TII.AGREGACAO, CP.AGREGACAO)	AS AGREGACAO,
			COALESCE(TII.QTDE_LIMITE_VENDA,0) 		AS QTDE_LIMITE_VENDA
		FROM
			TEMP_INFO_ITENS TII 
			FULL JOIN TEMP_INFO_CAMPANHA CP ON TII.CD_PROD = CP.CD_PROD;					
				
		
/******************************************************************************************************************************************************/
/******************************************************************************************************************************************************/

END;

 $BODY$
  LANGUAGE PLPGSQL VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION PUBLIC.p_est_prod_desc_final(INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER)
  OWNER TO POSTGRES;




CREATE OR REPLACE FUNCTION public.p_est_prod_desc_final(    
	IN INTEGER,
    IN INTEGER,
    IN INTEGER,
    IN INTEGER,
    IN INTEGER, 
	
    OUT VERSAO            CHARACTER VARYING,
    OUT CD_TP_DESCONTO    INTEGER,
    OUT CD_PROD           INTEGER,
    OUT CD_TBL_DESC       INTEGER,
    OUT DS_TBL_DESC       CHARACTER VARYING,
    OUT QT_IT             INTEGER,
    OUT VLR_DESC_ITEM     DOUBLE PRECISION,
    OUT VLR_DESCONTO      DOUBLE PRECISION,
    OUT VLR_ITEM 		  DOUBLE PRECISION,
    OUT AGREGACAO 		  INTEGER,
	OUT QTDE_LIMITE_VENDA INTEGER)
  RETURNS SETOF RECORD AS
 
$BODY$
	 
BEGIN

	--	returnRec = p_est_prod_desc_final($1,$2,$3,$4,$5,-1);
	 
	 return QUERY select * from p_est_prod_desc_final($1,$2,$3,$4,$5,-1);
END;
-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.p_est_prod_desc_final(integer, integer, integer, integer, integer)
  OWNER TO postgres;

